//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Create 1.0
import wesual.Ui     1.0
import wesual.Util   1.0


UiDialog {
    id : importDialog

    function downloadFiles(files) {
        downloader.downloadFiles(files);
        importDialog.show();
    }

    readonly property ResourceDownloader importer : ResourceDownloader {
        id : downloader

        onFinished : importDialog.accept(files)
    }

    label : qsTrId("b9133d448387387d")

    contentDelegate : Item {
        implicitWidth  : 450
        implicitHeight : content.implicitHeight + 2 * content.anchors.margins

        Column {
            id : content

            anchors.fill    : parent
            anchors.margins : 14

            spacing : 8

            UiText {
                text : qsTrId("41445fc154e86ac7")
                    .arg(downloader.filesDone).arg(downloader.filesTotal)

                anchors {
                    left  : parent.left
                    right : parent.right
                }
            }

            UiProgressBar {
                progress : downloader.progress
                animated : true

                anchors {
                    left  : parent.left
                    right : parent.right
                }
            }
        }
    }

    flags   : UiDialog.RejectOnCloseEvent | UiDialog.RejectOnEscape
    buttons : UiDialogButton {
        role : UiDialogButton.CancelRole
    }

    onRejected : downloader.abort()
}
